#!/bin/sh

PRESERVEDPATH=$1

. /etc/exorint.funcs

# This function will be used since EPAD is not available and the etc system.ini file is in PRESERVEDPATH
writeIniParam() {
	section=$1
	key=$2
	file=$3

	[ -f $file ] || return

	if ( cat $file | grep -q "^\[$section\]" ); then
		sed -i "s:^\[$section\].*:[$section]\n$key:" $file
	else
		echo >> $file
		echo "[$section]" >> $file
		echo -e $key >> $file
	fi
}

# web_Server/https_only and fs/sdcard/noAuto have changed their default from true to false
# so to preserve them we need to set them explicitly if they were not set

if [ "$( exorint_param "services\web_server\https_only" )" = "" ]; then
	writeIniParam services 'web_server\\https_only=false' $PRESERVEDPATH/etc/EPAD/system.ini
fi

if [ "$( exorint_fparam "options\fs\sdcard\noAuto" )" = "" ]; then
	mount -o remount,rw /mnt/factory
	writeIniParam options 'fs\\sdcard\\noAuto=false' /mnt/factory/etc/EPAD/system.ini
	mount -o remount,ro /mnt/factory
fi

mount -o remount,rw /
cp $PRESERVEDPATH/etc/EPAD/system.ini /

sync
